#ident "$Id: scsi.h,v 1.4 1991/05/06 00:05:01 chris Exp $"

/*
 $Log: scsi.h,v $
 * Revision 1.4  1991/05/06  00:05:01  chris
 * Add defines for the direction flags.
 * Add the sense parameter to all prototypes
 * Add the prototype for the SCSIGeneric() function
 *
 * Revision 1.3  1991/03/21  11:10:18  chris
 * moved all errormessage defines to the new header file scsierr.h
 *
 * Revision 1.2  1991/03/04  16:52:18  chris
 * Changes made to prototypes to implement as DLL
 *
 * Revision 1.1  1991/03/04  01:19:22  chris
 * Initial revision
 *
 */

static char *scsi_h_id = "$Id: scsi.h,v 1.4 1991/05/06 00:05:01 chris Exp $";


#pragma pack(1)

typedef struct _ainquiry {
  int   adapter_num;
  int   adapters;
  int   target_id;
  char  manager_id[17];
  char  adapter_id[17];
} aspiinquiry;

typedef struct _sinquiry {
  unsigned per_type : 5;
  unsigned per_qualify : 3;
  unsigned dev_qualify : 7;
  unsigned rbm : 1;
  unsigned ansi_ver : 3;
  unsigned ecma_ver : 3;
  unsigned iso_ver : 2;
  unsigned response_fmt : 4;
  unsigned _reserved1 : 3;
  unsigned anec : 1;
  unsigned len : 8;
  unsigned _reserved2 : 8;
  unsigned _reserved3 : 8;
  unsigned _reserved4 : 1;
  unsigned cmd_que : 1;
  unsigned cache : 1;
  unsigned linked : 1;
  unsigned sync : 1;
  unsigned bus16 : 1;
  unsigned bus32 : 1;
  unsigned reladr : 1;
  char vendor_id[8];
  char product_id[16];
  char revision[4];
  unsigned char vendor[20];
  unsigned char _reserved5[40];
} scsiinquiry;

typedef struct _capacity  {
  DWORD blocks;
  DWORD block_len;
} capacity;

typedef struct _blocklimit  {
  DWORD max;
  DWORD min;
} blocklimit;

/*
 * Mode Select/Sense parameter list header and block descriptor
 *  fields converted to internal format.
 */
typedef struct modeBlockSz {

  struct {
    unsigned char   dataLen;
    unsigned char   mediumType;
    unsigned char   devSpecific;
    unsigned char   bdescLen;
  } header;

  struct {
    unsigned char   denCode;
    DWORD           nBlocks;
    DWORD           blockLen;
  } bdesc;

} modeBlockSz;


/*
 * The direction flags for use with the SCSIGeneric() command
 * These flags are also defined in ada.h for the AdaGeneric() command
 */

#ifndef _DIR_FLAGS_
#define _DIR_FLAGS_
#define DIR_NOT_CHECKED 0
#define DIR_INPUT 1
#define DIR_OUTPUT 2
#define DIR_NO_TRANSFER 3
#endif

/*
 * Function prototypes:
 */
int HostAdapterInquiry(struct _ainquiry *inq);
int GetDeviceTyp(int adapter, int target_id, int lun);
int SCSIInquiry(int adapter, int target_id, int lun,
                        struct _sinquiry far *inq, unsigned char *sense);
int SCSIResetDevice(int adapter, int target_id, int lun);
int SCSIReadCapacity(int adapter, int target_id, int lun,
                     struct _capacity *cap, unsigned char *sense);
int SCSISeekRead(int adapter, int target_id, int lun, unsigned long buf,
                 unsigned long len, unsigned long blockadr, int l2bf,
                 unsigned char *sense);
int SCSIReZeroUnit(int adapter, int target_id, int lun, unsigned char *sense);
int SCSIStartStop(int adapter, int target_id, int lun,
                          int start, int eject, unsigned char *sense);
int SCSISeekWrite(int adapter, int target_id, int lun,
			     unsigned long buf, unsigned long len,
			     unsigned long blockadr, int l2bf,
                             unsigned char *sense);
int SCSISeekWriteVerify(int adapter, int target_id, int lun,
				   unsigned long buf, unsigned long len,
				   unsigned long blockadr, int l2bf, 
                                   int bcheck, unsigned char *sense);
int SCSISeek(int adapter, int target_id, int lun,
                        unsigned long blockadr, unsigned char *sense);
int SCSIFormatUnit(int adapter, int target_id, int lun,
                              int interleave, unsigned char *sense);
int SCSIAllowRemoval(int adapter, int target_id, int lun,
                                int prevent, unsigned char *sense);
int SCSIErase(int adapter, int target_id, int lun, int immediate,
                         int lng, unsigned char *sense);
int SCSILoad(int adapter, int target_id, int lun, int immediate,
			int load, int retention, int eot,
                        unsigned char *sense);
int SCSIRead(int adapter, int target_id, int lun,
                        char far *buf, DWORD xferlen, int sili,
                        int fixed, unsigned char *sense);
int SCSIReadBlockLimits(int adapter, int target_id, int lun,
                                   struct _blocklimit *lim,
                                   unsigned char *sense);
int SCSIReleaseUnit(int adapter, int target_id, int lun,
                               unsigned char *sense);
int SCSIReserveUnit(int adapter, int target_id, int lun,
                               unsigned char *sense);
int SCSIRewind(int adapter, int target_id, int lun, int immediate,
                          unsigned char *sense);
int SCSISpace(int adapter, int target_id, int lun, int code,
                         long count, unsigned char *sense);
int SCSIWrite(int adapter, int target_id, int lun,
                         char far *buf, DWORD xferlen,
                         int fixed, unsigned char *sense);
int SCSIWriteFilemarks(int adapter, int target_id, int lun,
                                  unsigned long len, int setmark,
                                  int immediate, unsigned char *sense);

int SCSIModeSense(int adapter, int target_id, int lun,
                    modeBlockSz *mode, unsigned char *sense);
int SCSIModeSelect(int adapter, int target_id, int lun,
                    char modePf,
                    modeBlockSz *mode, unsigned char *sense);

int SCSIGeneric(int adapter, int target_id, int lun,
                           unsigned char *ccb, int ccblength,
                           unsigned char *sense, int senselength,
			   DWORD data, DWORD datalength, int direction);
